package com.ejie.ab04b.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab04b.constantes.ConstantesDocumentos;
import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.model.VfichaOs2;
import com.ejie.ab04b.util.CaracteresRarosUtil;

@Service(value = "generacionPDFFichaOS2Impl")
public class GeneracionPDFFichaOS2Impl implements GeneracionPDFFichaOS2Service {

	@Autowired
	private VfichaOs2Service vfichaOs2Service;

	/**
	 * Devuelve un InputStream con el documento pdf.
	 * 
	 *  listadoFolderNumber
	 *            String[]
	 *  Inputstream
	 *
	 * @param listadoFolderNumber the listado folder number
	 * @return the pdf
	 * @throws AB04BException the AB 04 B exception
	 */
	public InputStream getPDF(String[] listadoFolderNumber)
			throws AB04BException {
		try {
			String xslFichero = "";
			xslFichero = ConstantesDocumentos.FICHA_OS2_XSL;

			InputStream inputStream = null;

			StringBuffer xmlPdf = getXml(listadoFolderNumber);
			String xml = CaracteresRarosUtil.htmlEscape(xmlPdf.toString());
			StringReader lxmlReader = new StringReader(xml);
			// Inicializo transformer
			Transformer transformer = pdfTransformacionInit(xslFichero);
			// Ejecuto transformación
			ByteArrayOutputStream byteOut = pdfTransformacionExec(transformer,
					lxmlReader, org.apache.fop.apps.Driver.RENDER_PDF);

			byte[] bytes = byteOut.toByteArray();
			inputStream = new ByteArrayInputStream(bytes);

			byteOut.close();

			return inputStream;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Inicializa la transformacion a PDF.
	 * 
	 *  xslFichero
	 *            String
	 *  Transformer
	 *
	 * @param xslFichero the xsl fichero
	 * @return the transformer
	 * @throws AB04BException the AB 04 B exception
	 */
	private Transformer pdfTransformacionInit(String xslFichero)
			throws AB04BException {
		try {

			TransformerFactory tFactory = TransformerFactory.newInstance();
			// org.apache.fop.configuration.Configuration.put("baseDir", "c:/");
			return tFactory.newTransformer(new StreamSource(xslFichero));
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}

	}

	/**
	 * Ejecuta la transformación PDF.
	 * 
	 *  transformer
	 *            transformer
	 *  strReader
	 *            strReader
	 *  renderer
	 *            renderer
	 *  ByteArrayOutputStream
	 *
	 * @param transformer the transformer
	 * @param strReader the str reader
	 * @param renderer the renderer
	 * @return the byte array output stream
	 * @throws AB04BException the AB 04 B exception
	 */
	private ByteArrayOutputStream pdfTransformacionExec(
			Transformer transformer, StringReader strReader, int renderer)
			throws AB04BException {

		try {
			DOMResult domResultado = new DOMResult();

			transformer.transform(new StreamSource(strReader), domResultado);

			org.apache.fop.apps.Driver driver = new org.apache.fop.apps.Driver();

			driver.setRenderer(renderer);

			ByteArrayOutputStream byteOut = new ByteArrayOutputStream();

			driver.setOutputStream(byteOut);
			driver.render((org.w3c.dom.Document) domResultado.getNode());
			driver.reset();

			return byteOut;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Obtiene los datos y genera el XML.
	 * 
	 *  listadoFolderNumber
	 *            String[]
	 *  StringBuffer
	 *
	 * @param listadoFolderNumber the listado folder number
	 * @return the xml
	 * @throws AB04BException the AB 04 B exception
	 */
	private StringBuffer getXml(String[] listadoFolderNumber)
			throws AB04BException {
		try {

			VfichaOs2 vfichaOs2 = new VfichaOs2();
			StringBuffer xml = new StringBuffer();
			xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			xml.append("<impresiones>");

			for (int i = 0; i < listadoFolderNumber.length; i++) {
				vfichaOs2 = obtenerfichaOs2(listadoFolderNumber[i]);
				xml.append("<imprimirOS2>");
				xml.append("<razonSocialEmpresa>");
				xml.append((vfichaOs2.getRazonsocial() != null) ? vfichaOs2
						.getRazonsocial() : "");
				xml.append("</razonSocialEmpresa>");
				xml.append("<numeroDocumentoEmpresa>");
				xml.append((vfichaOs2.getNumerodocumentoempresa() != null) ? vfichaOs2
						.getNumerodocumentoempresa() : "");
				xml.append("</numeroDocumentoEmpresa>");
				xml.append("<cnaeDescripcion>");
				xml.append((vfichaOs2.getCenaedescripcion() != null) ? vfichaOs2
						.getCenaedescripcion() : "");
				xml.append("</cnaeDescripcion>");
				xml.append("<actividadEconomica>");
				xml.append((vfichaOs2.getActividadeconomica() != null) ? vfichaOs2
						.getActividadeconomica() : "");
				xml.append("</actividadEconomica>");
				xml.append("<realizaTrabajoAnexoIEmpresa>");
				xml.append((vfichaOs2.getRealizatrabajoanexoiempresa() != null) ? vfichaOs2
						.getRealizatrabajoanexoiempresa() : "");
				xml.append("</realizaTrabajoAnexoIEmpresa>");
				xml.append("<noRealizaTrabajoAnexoIEmpresa>");
				xml.append((vfichaOs2.getNorealizatrabajoanexoiempresa() != null) ? vfichaOs2
						.getNorealizatrabajoanexoiempresa() : "");
				xml.append("</noRealizaTrabajoAnexoIEmpresa>");
				xml.append("<trabajoAnexoIEmpresa>");
				xml.append((vfichaOs2.getTrabajoanexoiempresa() != null) ? vfichaOs2
						.getTrabajoanexoiempresa() : "");
				xml.append("</trabajoAnexoIEmpresa>");
				xml.append("<direccionEmpresa>");
				xml.append((vfichaOs2.getDireccionempresa() != null) ? vfichaOs2
						.getDireccionempresa() : "");
				xml.append("</direccionEmpresa>");
				xml.append("<plantillaTotalEmpresa>");
				xml.append((vfichaOs2.getPlantillatotalempresa() != null) ? vfichaOs2
						.getPlantillatotalempresa() : "");
				xml.append("</plantillaTotalEmpresa>");
				xml.append("<territorioEmpresa>");
				xml.append((vfichaOs2.getTerritorioempresa() != null) ? vfichaOs2
						.getTerritorioempresa() : "");
				xml.append("</territorioEmpresa>");
				xml.append("<cpEmpresa>");
				xml.append((vfichaOs2.getCp() != null) ? vfichaOs2.getCp() : "");
				xml.append("</cpEmpresa>");
				xml.append("<municipioEmpresa>");
				xml.append((vfichaOs2.getMunoicipioempresa() != null) ? vfichaOs2
						.getMunoicipioempresa() : "");
				xml.append("</municipioEmpresa>");
				xml.append("<emailEmpresa>");
				xml.append((vfichaOs2.getEmailempresa() != null) ? vfichaOs2
						.getEmailempresa() : "");
				xml.append("</emailEmpresa>");
				xml.append("<httpEmpresa>");
				xml.append((vfichaOs2.getHttpempresa() != null) ? vfichaOs2
						.getHttpempresa() : "");
				xml.append("</httpEmpresa>");
				xml.append("<faxEmpresa>");
				xml.append((vfichaOs2.getFaxempresa() != null) ? vfichaOs2
						.getFaxempresa() : "");
				xml.append("</faxEmpresa>");
				xml.append("<telefonEmpresa>");
				xml.append((vfichaOs2.getTelefonoempresa() != null) ? vfichaOs2
						.getTelefonoempresa() : "");
				xml.append("</telefonEmpresa>");
				xml.append("<domicilioDireccionCentro>");
				xml.append((vfichaOs2.getDomiciliodireccioncentro() != null) ? vfichaOs2
						.getDomiciliodireccioncentro() : "");
				xml.append("</domicilioDireccionCentro>");
				xml.append("<municipioDireccionCentro>");
				xml.append((vfichaOs2.getMunicipiodireccioncentro() != null) ? vfichaOs2
						.getMunicipiodireccioncentro() : "");
				xml.append("</municipioDireccionCentro>");
				xml.append("<thDireccionCentro>");
				xml.append((vfichaOs2.getThdireccioncentro() != null) ? vfichaOs2
						.getThdireccioncentro() : "");
				xml.append("</thDireccionCentro>");
				xml.append("<numeroApertura>");
				xml.append((vfichaOs2.getNumeroapertura() != null) ? vfichaOs2
						.getNumeroapertura() : "");
				xml.append("</numeroApertura>");

				xml.append(this.anadirDatosAdicionales(vfichaOs2));

				xml.append("<auditoriaRealizada>");
				xml.append((vfichaOs2.getAuditoriarealizada() != null) ? vfichaOs2
						.getAuditoriarealizada() : "");
				xml.append("</auditoriaRealizada>");
				xml.append("<auditoriaNoRealizada>");
				xml.append((vfichaOs2.getAuditorianorealizada() != null) ? vfichaOs2
						.getAuditorianorealizada() : "");
				xml.append("</auditoriaNoRealizada>");
				xml.append("<fechaUltimaRealizacion>");
				xml.append((vfichaOs2.getFechaultimarealizacion() != null) ? vfichaOs2
						.getFechaultimarealizacion() : "");
				xml.append("</fechaUltimaRealizacion>");
				xml.append("<empresaAuditora>");
				xml.append((vfichaOs2.getEmpresaauditora() != null) ? vfichaOs2
						.getEmpresaauditora() : "");
				xml.append("</empresaAuditora>");

				xml.append("</imprimirOS2>");
			}

			xml.append("</impresiones>");

			return xml;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Obtiene los datos para modalidad preventiva, especialidades y riesgos y
	 * genera el XML.
	 * 
	 *  vfichaOs2
	 *            VfichaOs3
	 *  String
	 *
	 * @param vfichaOs2 the vficha os 2
	 * @return the string
	 */
	private String anadirDatosAdicionales(VfichaOs2 vfichaOs2) {
		String modalidad11 = "";
		String modalidad12 = "";
		String modalidad13 = "";
		String modalidad14 = "";
		String modalidad15 = "";

		if (vfichaOs2.getTipmpr1() != null) {
			if (vfichaOs2.getTipmpr1().equals("1")) {
				modalidad11 = (vfichaOs2.getNommpr1() != null) ? vfichaOs2
						.getNommpr1() : "" + ".";
			} else if (vfichaOs2.getTipmpr1().equals("2")) {
				modalidad12 = (vfichaOs2.getNommpr1() != null) ? vfichaOs2
						.getNommpr1() : "" + ".";
			} else if (vfichaOs2.getTipmpr1().equals("3")) {
				modalidad13 = (vfichaOs2.getNommpr1() != null) ? vfichaOs2
						.getNommpr1() : "" + ".";
			} else if (vfichaOs2.getTipmpr1().equals("4")) {
				modalidad14 = (vfichaOs2.getNommpr1() != null) ? vfichaOs2
						.getNommpr1() : "" + ".";
			} else if (vfichaOs2.getTipmpr1().equals("5")) {
				modalidad15 = (vfichaOs2.getNommpr1() != null) ? vfichaOs2
						.getNommpr1() : "" + ".";
			}
		}
		String modalidad21 = "";
		String modalidad22 = "";
		String modalidad23 = "";
		String modalidad24 = "";
		String modalidad25 = "";
		if (vfichaOs2.getTipmpr2() != null) {
			if (vfichaOs2.getTipmpr2().equals("1")) {
				modalidad21 = (vfichaOs2.getNommpr2() != null) ? vfichaOs2
						.getNommpr2() : "";
			} else if (vfichaOs2.getTipmpr2().equals("2")) {
				modalidad22 = (vfichaOs2.getNommpr2() != null) ? vfichaOs2
						.getNommpr2() : "";
			} else if (vfichaOs2.getTipmpr2().equals("3")) {
				modalidad23 = (vfichaOs2.getNommpr2() != null) ? vfichaOs2
						.getNommpr2() : "";
			} else if (vfichaOs2.getTipmpr2().equals("4")) {
				modalidad24 = (vfichaOs2.getNommpr2() != null) ? vfichaOs2
						.getNommpr2() : "";
			} else if (vfichaOs2.getTipmpr2().equals("5")) {
				modalidad25 = (vfichaOs2.getNommpr2() != null) ? vfichaOs2
						.getNommpr2() : "";
			}
		}
		StringBuffer especialidad1 = new StringBuffer();
		especialidad1.append("");
		StringBuffer especialidad2 = new StringBuffer();
		especialidad2.append("");
		StringBuffer especialidad3 = new StringBuffer();
		especialidad3.append("");
		StringBuffer especialidad4 = new StringBuffer();
		especialidad4.append("");
		if (vfichaOs2.getTopseg1() != null) {
			especialidad1.append(vfichaOs2.getTopseg1());
		}
		if (vfichaOs2.getTopseg2() != null) {
			especialidad1.append(",").append(vfichaOs2.getTopseg2());
		}
		if (vfichaOs2.getTophig1() != null) {
			especialidad2.append(vfichaOs2.getTophig1());
		}
		if (vfichaOs2.getTophig2() != null) {
			especialidad2.append(",").append(vfichaOs2.getTophig2());
		}
		if (vfichaOs2.getToper1() != null) {
			especialidad3.append(vfichaOs2.getToper1());
		}
		if (vfichaOs2.getToper2() != null) {
			especialidad3.append(",").append(vfichaOs2.getToper2());
		}
		if (vfichaOs2.getTopvig1() != null) {
			especialidad4.append(vfichaOs2.getTopvig1());
		}
		if (vfichaOs2.getTopvig2() != null) {
			especialidad4.append(",").append(vfichaOs2.getTopvig2());
		}

		String riesgos11 = "";
		String riesgos12 = "";
		String riesgos13 = "";
		String riesgos14 = "";
		String riesgos15 = "";
		if (vfichaOs2.getTiprie1() != null) {
			if (vfichaOs2.getTiprie1().equals("1")) {
				riesgos11 = vfichaOs2.getNomrie1() + ".";
			} else if (vfichaOs2.getTiprie1().equals("2")) {
				riesgos12 = (vfichaOs2.getNomrie1() != null) ? vfichaOs2
						.getNomrie1() : "" + ".";
			} else if (vfichaOs2.getTiprie1().equals("3")) {
				riesgos13 = (vfichaOs2.getNomrie1() != null) ? vfichaOs2
						.getNomrie1() : "" + ".";
			} else if (vfichaOs2.getTiprie1().equals("4")) {
				riesgos14 = (vfichaOs2.getNomrie1() != null) ? vfichaOs2
						.getNomrie1() : "" + ".";
			} else if (vfichaOs2.getTiprie1().equals("5")) {
				riesgos15 = (vfichaOs2.getNomrie1() != null) ? vfichaOs2
						.getNomrie1() : "" + ".";
			}
		}
		String riesgos21 = "";
		String riesgos22 = "";
		String riesgos23 = "";
		String riesgos24 = "";
		String riesgos25 = "";
		if (vfichaOs2.getTiprie2() != null) {
			if (vfichaOs2.getTiprie2().equals("1")) {
				riesgos21 = (vfichaOs2.getNomrie2() != null) ? vfichaOs2
						.getNomrie2() : "";
			} else if (vfichaOs2.getTiprie2().equals("2")) {
				riesgos22 = (vfichaOs2.getNomrie2() != null) ? vfichaOs2
						.getNomrie2() : "";
			} else if (vfichaOs2.getTiprie2().equals("3")) {
				riesgos23 = (vfichaOs2.getNomrie2() != null) ? vfichaOs2
						.getNomrie2() : "";
			} else if (vfichaOs2.getTiprie2().equals("4")) {
				riesgos24 = (vfichaOs2.getNomrie2() != null) ? vfichaOs2
						.getNomrie2() : "";
			} else if (vfichaOs2.getTiprie2().equals("5")) {
				riesgos25 = (vfichaOs2.getNomrie2() != null) ? vfichaOs2
						.getNomrie2() : "";
			}
		}

		StringBuffer xml = new StringBuffer();
		xml.append("<modalidad11>");
		xml.append(modalidad11);
		xml.append("</modalidad11>");
		xml.append("<modalidad12>");
		xml.append(modalidad12);
		xml.append("</modalidad12>");
		xml.append("<modalidad13>");
		xml.append(modalidad13);
		xml.append("</modalidad13>");
		xml.append("<modalidad14>");
		xml.append(modalidad14);
		xml.append("</modalidad14>");
		xml.append("<modalidad15>");
		xml.append(modalidad15);
		xml.append("</modalidad15>");
		xml.append("<modalidad21>");
		xml.append(modalidad21);
		xml.append("</modalidad21>");
		xml.append("<modalidad22>");
		xml.append(modalidad22);
		xml.append("</modalidad22>");
		xml.append("<modalidad23>");
		xml.append(modalidad23);
		xml.append("</modalidad23>");
		xml.append("<modalidad24>");
		xml.append(modalidad24);
		xml.append("</modalidad24>");
		xml.append("<modalidad25>");
		xml.append(modalidad25);
		xml.append("</modalidad25>");
		xml.append("<especialidad1>");
		xml.append(especialidad1.toString());
		xml.append("</especialidad1>");
		xml.append("<especialidad2>");
		xml.append(especialidad2.toString());
		xml.append("</especialidad2>");
		xml.append("<especialidad3>");
		xml.append(especialidad3.toString());
		xml.append("</especialidad3>");
		xml.append("<especialidad4>");
		xml.append(especialidad4.toString());
		xml.append("</especialidad4>");
		xml.append("<riesgos11>");
		xml.append(riesgos11);
		xml.append("</riesgos11>");
		xml.append("<riesgos12>");
		xml.append(riesgos12);
		xml.append("</riesgos12>");
		xml.append("<riesgos13>");
		xml.append(riesgos13);
		xml.append("</riesgos13>");
		xml.append("<riesgos14>");
		xml.append(riesgos14);
		xml.append("</riesgos14>");
		xml.append("<riesgos15>");
		xml.append(riesgos15);
		xml.append("</riesgos15>");
		xml.append("<riesgos21>");
		xml.append(riesgos21);
		xml.append("</riesgos21>");
		xml.append("<riesgos22>");
		xml.append(riesgos22);
		xml.append("</riesgos22>");
		xml.append("<riesgos23>");
		xml.append(riesgos23);
		xml.append("</riesgos23>");
		xml.append("<riesgos24>");
		xml.append(riesgos24);
		xml.append("</riesgos24>");
		xml.append("<riesgos25>");
		xml.append(riesgos25);
		xml.append("</riesgos25>");
		return xml.toString();

	}

	/**
	 * /** Devuelve el objeto ficha os2 con los datos.
	 * 
	 *  pkFicha
	 *            String
	 *  VfichaOs2
	 *
	 * @param pkFicha the pk ficha
	 * @return the vficha os 2
	 */
	private VfichaOs2 obtenerfichaOs2(String pkFicha) {
		String numExp = "";
		VfichaOs2 fichaOs2 = new VfichaOs2();

		numExp = pkFicha.replaceAll("/", "-");
		fichaOs2.setNumexp(numExp);

		return this.vfichaOs2Service.find(fichaOs2);
	}
}
